﻿<%@ Page Language="C#" AutoEventWireup="true" EnableSessionState="True" Theme="Voxco"
    Trace="false" Async="true"
    Inherits="Voxco.Reporting.Report_CustomStatistic" Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="ReportCustomStatistics.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>Voxco Reporting</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="../css/ReportGroupTree.css" rel="stylesheet" type="text/css" />
    <style type="text/css">@import url( css/voxco_mng.css ); </style>
    <link href="~/css/ReportingStyleSheet.css" rel="stylesheet" type="text/css" />
    <link href="../css/ReportingStyleSheet.css" rel="stylesheet" type="text/css" />

</head>
<body id="neutral" runat="server">
    <form id="Form1" method="post" runat="server" style="height: 100%;">
		<telerik:RadScriptBlock ID="RadScriptBlock" runat="server">
			<script type="text/javascript">
	        	        
			    if (Telerik.Web.UI.RadTreeView != undefined) {
			        Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
			            return "{\"expandedNodes\":" + this._expandedNodesJson +
			                ",\"collapsedNodes\":" + this._collapsedNodesJson +
			                ",\"logEntries\":" + this._logEntriesJson +
			                ",\"selectedNodes\":" + this._selectedNodesJson +
			                ",\"checkedNodes\":" + this._checkedNodesJson +
			                ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
			        }
			    }

			    function GetRadWindow()
				{
					var oWindow = null;
					if (window.radWindow) oWindow = window.radWindow;
					else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;
					return oWindow;
				}
				function CloseWnd()
				{
					var oWnd = GetRadWindow();					
					oWnd.Close();					
				}
				function OnCheckedNode(node, eventArgs)
				{
					var tree = $find("<%= treeSelectedResultCodes.ClientID %>");
					var _nodes = tree.get_checkedNodes();
					if(_nodes.length >= 2)
					{					
						if (_nodes[1].get_value())
						{
							if(_nodes[0].get_value() != node.get_checkedNodes()[1].get_value())
							{
								_nodes[0].uncheck();
							}
						}
					}
					$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("SetSelectedNodes");
					return false;
				}
			</script>
		</telerik:RadScriptBlock>
		
        <telerik:RadAjaxManager ID="MainAjaxManager" runat="server"
            EnableAJAX="true">
        </telerik:RadAjaxManager>
      
        <asp:ObjectDataSource ID="SelectedResultCodeDataSource" runat="server" SelectMethod="GetSelectedStatistics"
            TypeName="Voxco.Reporting.DataSource.ResultCodes"></asp:ObjectDataSource>
            
        <telerik:RadScriptManager ID="SciptManager1" runat="server"></telerik:RadScriptManager>
        
        <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" MinDisplayTime="200" InitialDelayTime="0">
			<VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
		</telerik:RadAjaxLoadingPanel>
        
        <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" Height="100%" Width="100%" OnAjaxRequest="MainAjaxManager_OnAjaxRequest" LoadingPanelID="MainAjaxLoadingPanel" EnablePageHeadUpdate="false">			
            <asp:Panel ID="labelSelectedItems" runat="server" GroupingText="<%$ Resources:Resource, CostomStatistics %>" ScrollBars="Auto">                        
				<table>
					<tr valign="top">
						<td style="width:40%;height:300px;" >
							<telerik:RadTreeView ID="treeSelectedResultCodes"
							AllowNodeEditing="True" 
							SingleExpandPath="False"  
							MultipleSelect="False" 
							CheckBoxes="True" 
							DataSourceID="SelectedResultCodeDataSource"
							DataValueField="NodeId" 
							DataTextField="NodeLabel" 
							DataFieldID="NodeId" 
							DataFieldParentID="ParentNodeId"
							OnNodeDataBound="treeSelectedResultCodes_OnNodeBound" 
							EnableDragAndDrop="True"  
							EnableDragAndDropBetweenNodes="True"
							OnClientNodeChecked="OnCheckedNode"
							Height="300px" runat="server">
							</telerik:RadTreeView>
						</td>
						<td style="width: 60% ;height:310;" valign="top">
							<asp:Label ID="StatisticsNameLabel" Font-Size="0.7em" runat="server" Text="<%$ Resources:Resource, StatisticsName %>"></asp:Label>
							<br />
							<telerik:RadTextBox ID="txtStatisticsName" runat="server" Width="420px">
							</telerik:RadTextBox>                                
							<br />
							<br />
							<table width="100%"  border="0">
								<tr valign="top">
									<td>
										<asp:ImageButton ID="btnAddNumerator" runat="server" ImageUrl="~/icons/arrow_right_blue.png" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" CommandName="AddNumerator" OnClick="btnAddNumerator_Click" />
									</td>
									<td>
										<asp:Label ID="Label1" Font-Size="0.7em"  runat="server" Text="<%$ Resources:Resource, Numerator %>"></asp:Label>
									</td>
									<td align="right">
										<telerik:RadTextBox ID="txtNumerator" ReadOnly="true" Enabled="false" Width="280px" runat="server">
										</telerik:RadTextBox>
									</td>
								</tr>
								<tr valign="top">
									<td>
										<asp:ImageButton ID="btnAddDenominator" runat="server" ImageUrl="~/icons/arrow_right_blue.png"
										ToolTip="<%$ Resources:Resource, AddSelectedItems %>" CommandName="AddDenominator" OnClick="btnAddDenominator_Click" />
									</td>
									<td>
										<asp:Label ID="Label2" Font-Size="0.7em" runat="server" Text="<%$ Resources:Resource, Denominator %>"></asp:Label>
									</td>
									<td align="right">
										<telerik:RadTextBox ID="txtDenominator" ReadOnly="true" Enabled="false" runat="server" Width="280px">
										</telerik:RadTextBox>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<asp:CheckBox ID="chkDisplayPercentage" Font-Size="0.7em" runat="server" AutoPostBack="false" Text="<%$ Resources:Resource, DisplayPercentage %>">
										</asp:CheckBox>
									</td>
									<td align="right">
										<asp:RadioButtonList ID="DataStastisticOptions" runat="server" CellPadding="0" AutoPostBack="false" CellSpacing="5" Font-Size="8pt" RepeatDirection="Vertical">
											<asp:ListItem Selected="True" Value="Round" Text="<%$ Resources:Resource, Round %>"></asp:ListItem>
											<asp:ListItem Value="Truncate" Text="<%$ Resources:Resource, Truncate %>"></asp:ListItem>
											<asp:ListItem Value="RoundUp" Text="<%$ Resources:Resource, RoundUp %>"></asp:ListItem>
										</asp:RadioButtonList>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<asp:Label ID="Label3" Font-Size="0.7em" runat="server" Text="<%$ Resources:Resource, NumberOfDecimal %>"></asp:Label>
									</td>
									<td align="right">
										<telerik:RadTextBox ID="txtNumberOfDecimal" Width="150px" Text="2" runat="server">
										</telerik:RadTextBox>
									</td>
								</tr>
								<tr>
									<td align="right" colspan="3">
										<asp:Button ID="btnCancel" runat="server" Text="<%$ Resources:Resource, Cancel %>" style="margin-top: 26px;" OnClick="btnCancel_Click"></asp:Button>
										<asp:Button ID="btnSubmit" runat="server" Text="<%$ Resources:Resource, Ok %>" style="margin-top: 26px;" OnClick="btnOk_clicked"></asp:Button>            
									</td>
								</tr>
							</table>                            
						</td>
					</tr>
				</table>  
			</asp:Panel>   					                              
        </telerik:RadAjaxPanel>
    </form>
</body>
</html>
